/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.asm.util.ASMType;
import oracle.install.asm.util.ASMUtilityErrorCode;
import oracle.install.commons.system.process.AbstractLineProcessor;

class SRVCTLOpOutputParser
extends AbstractLineProcessor {
    private static final Logger logger = Logger.getLogger(SRVCTLOpOutputParser.class.getName());
    private boolean stopProcessing;
    private ASMUtilityErrorCode errorCode;
    private boolean asmPresent;
    private ArrayList<String> nodeList = new ArrayList();
    private boolean isUpgrade = false;
    private ASMType type = ASMType.LOCAL;

    SRVCTLOpOutputParser() {
    }

    public List<String> getNodeList() {
        return this.nodeList;
    }

    public void setUpgrade(boolean isUpgrade) {
        this.isUpgrade = isUpgrade;
    }

    public void processLine(String line, int lineNumber) {
        if (!this.stopProcessing) {
            if (line.indexOf("PROC-32") != -1) {
                this.errorCode = ASMUtilityErrorCode.INTERNAL_ERROR;
                this.stopProcessing = true;
            } else {
                logger.log(Level.INFO, "Parsing {0}", line);
                if (this.isUpgrade) {
                    if (line == null || line.trim().length() == 0) {
                        this.asmPresent = false;
                    } else if (line.matches(".+not running.+")) {
                        this.asmPresent = true;
                        this.stopProcessing = true;
                    } else if (line.matches(".+running.+")) {
                        this.asmPresent = true;
                        this.stopProcessing = true;
                    }
                } else {
                    line = line.trim();
                    String[] tokens = line.split("\\s+");
                    String node = null;
                    boolean isASMPresent = false;
                    for (String token : tokens) {
                        if ((token = token.trim()).indexOf("=") <= -1) continue;
                        String[] keyValue = token.split("=");
                        String key = keyValue[0];
                        String value = keyValue[1].replace("{", "").replace("}", "");
                        if (key.equals("node_name")) {
                            node = value;
                        }
                        if (key.equals("inst_name") && value.matches("^\\+ASM.*")) {
                            isASMPresent = true;
                        }
                        if (!key.equals("count")) continue;
                        this.type = ASMType.REMOTE;
                    }
                    if (node != null && isASMPresent) {
                        this.nodeList.add(node);
                    }
                }
            }
        }
    }

    public ASMUtilityErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ASMUtilityErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isAsmPresent() {
        return this.asmPresent;
    }

    public ASMType getASMType() {
        return this.type;
    }
}

